<?php

class especial_Model_DbTable_Escoladiscprof extends Zsam_Db_Table {

	protected $_name 	= 'escoladiscprof';
	var $_autocomplet 	= array('ID','NOME_DISC','NOME_PROF') ;

 	var $_conf = array(
 			'ID' 					=> array("grid"=>true,'edit'=>'N'),
 			'EMPRESA' 				=> array("grid"=>true,'NULLABLE' => false),
 			'DISCIPLINA' 			=> array("editlevel"=>3,"grid"=>true,'NULLABLE' => false,'autocomplete'=>'Y'),
 			'PROFESSOR' 			=> array("editlevel"=>3,"grid"=>true,'NULLABLE' => false,'autocomplete'=>'Y'),
 			'NOME_PROF' 			=> array('edit'=>'N'),
 			'NOME_DISC' 			=> array('edit'=>'N'),
 			'FUNC_ALTERACAO' 		=> array('edit'=>'N'),
 			'DATA_ALTERACAO' 		=> array('edit'=>'N'),
 			'REVISAO' 				=> array('edit'=>'N'),

 	);

 	protected $_referenceMap    = array(

 			'EMPRESA' => array(
 					'columns'           => 'EMPRESA',
 					'refTableClass'     => 'core_Model_DbTable_Empresa',
 					'refColumns'        => 'CODIGO',
 					'refTitle'          => 'EMPRESA'
 			),

 			'PROFESSOR' => array(
 					'columns'           => 'PROFESSOR',
 					'refTableClass'     => 'core_Model_DbTable_Func',
 					'refColumns'        => 'CODIGO',
 					'refTitle'          => 'PROFESSOR'
 			),

 			'DISCIPLINA' => array(
 					'columns'           => 'DISCIPLINA',
 					'refTableClass'     => 'especial_Model_DbTable_Escoladisc',
 					'refColumns'        => 'ID',
 					'refTitle'          => 'DISCIPLINA'
 			),


 	);

 	public function beforeInsert(array $data)
 	{

 		$disc = new especial_Model_DbTable_Escoladisc();
 		$func = new core_Model_DbTable_func();

 		$dados_func = $func->find($data['PROFESSOR']);
 		$dados_disc = $disc->find($data['DISCIPLINA']);

 		$data['NOME_DISC'] = $dados_disc[0]['DISCIPLINA'];
 		$data['NOME_PROF'] = $dados_func[0]['NOME'];

 		return parent::beforeInsert($data);

 	}

 	public function beforeUpdate(array $data, $where)
 	{

 		$disc = new especial_Model_DbTable_Escoladisc();
 		$func = new core_Model_DbTable_func();

 		$dados_func = $func->find($data['PROFESSOR']);
 		$dados_disc = $disc->find($data['DISCIPLINA']);

 		$data['NOME_DISC'] = $dados_disc[0]['DISCIPLINA'];
 		$data['NOME_PROF'] = $dados_func[0]['NOME'];

 		return parent::beforeUpdate($data, $where);

 	}


}
?>