<?php

class serv_Model_DbTable_Manutitem extends Zsam_Db_Table {

	protected $_name  = 'manutitens';

	var $_autocomplet = array('ITEM_PROGR','NUM_ITEM','PRODUTO');

	protected $model;

	var $_conf = array(
			
			'CLIENTE' 				=> array('edit' => 'N', 'grid' => true, 'NULLABLE' => false),
			'ITEM_PROGR'                            => array('edit' => 'N'),
			'NUM_ITEM'                          	=> array('edit' => 'N', 'grid' => true, 'NULLABLE' => false),
                        'ID'					=> array('edit' => 'N'),
			'EMPRESA' 				=> array('edit' => 'N', 'grid' => true, 'NULLABLE' => false),
			'NATUREZA_OPERACAO'                     => array('NULLABLE' => false,'VP' => array("V"=>'VENDA',"L" => "LOCACAO")),
			'PRODUTO' 				=> array('autocomplete'=>'Y','NULLABLE' => false),
			'DESCRICAO_ITEM_NOVO'                   => array('edit' => 'N'),//nao esta sendo usado seria para cadastrar item novo
			'CUSTOM1'				=> array('edit' => 'N'),
			'DESC_CUSTOM1'                          => array("VP" => ""),
			'CUSTOM2'				=> array('edit' => 'N'),
			'DESC_CUSTOM2'                          => array("VP" => ""),
			'CUSTOM3'				=> array('edit' => 'N'),
			'DESC_CUSTOM3'                          => array("VP" => ""),
                        'CFOP' 					=> array('NULLABLE' => false, 'autocomplete'=>'N'),
                        'QUANTIDADE'                            => array('NULLABLE' => false),
			'DATANECESSIDADE'                       => array('edit' => 'N'),
			'PRECO_UNITARIO'                        => array('edit' => 'S','NULLABLE' => false),
			'PRECO_CUSTO'                           => array('title'=>'CUSTO_NF_ENVIO','edit' => 'N'),
			'PRECO_BASE'                            => array('edit' => 'N'),
                        'PRECO_MAXIMO'                          => array('edit' => 'N'),
                        'PRECO_TOTAL_ITEM'                      => array('edit' => 'N','NULLABLE' => false),
			'ESTOQUE'				=> array('title' => 'ESTOQUE_REVENDA','edit' => 'N'),
			'ESTOQUE_LOCACAO_NOVO'                  => array('edit' => 'N'),
			'ESTOQUE_LOCACAO_USADO'                 => array('edit' => 'N'),
			'RESERVAS_LOCACAO'                      => array('edit' => 'N','title'=>'pedidos_de_compra'),
			'RESERVAS_REVENDA'                      => array('edit' => 'N'),
			'BAIXA' 				=> array('edit' => 'N'),
                        'UNI'					=> array('edit' => 'N'),
                        'NCM'					=> array('edit' => 'N'),
                        'ORIGEM_SIT_TRIBUTARIA'                 => array('edit' => 'N'),/*DELETAR*/
                        'STIPI'					=> array('edit' => 'N'),/*DELETAR*/
                        'BASE_DE_CALCULO_IPI'                   => array('edit' => 'N'),/*DELETAR*/
                        'ALIQUOTA_IPI'                          => array('edit' => 'N'),/*DELETAR*/
                        'TOTAL_IPI'				=> array('edit' => 'N'),/*DELETAR*/
			'INFORMACAO_ADICIONAL'                  => array('help'=>'help_quebrar_linha_com_;'),
                        'FUNC_ALTERACAO'                        => array('edit' => 'N'),
			'DATA_ALTERACAO'                        => array('edit' => 'N'),
			'REVISAO' 				=> array('edit' => 'N'),
			'DATASINC' 				=> array('edit' => 'N')
	);
	
	var $_referenceMap = array(
			'PRODUTO' => array(
					'columns' 	=> 'PRODUTO',
					'refTitle' 	=> 'DESCRICAO'
			),

			'EMPRESA' => array(
					'columns' 		=> 'EMPRESA',
					'refTableClass' => 'core_Model_DbTable_Empresa',
					'refColumns' 	=> 'CODIGO',
					'refTitle' 		=> 'NOME'
			),

	        'CFOP' => array(
	                'columns' 		=> 'CFOP',
	                'refTableClass' => 'core_Model_DbTable_Cfop',
	                'refColumns' 	=> 'CODIGO',
	                'refTitle' 		=> 'CFOP'
	        ),

			

	);
	
	public function __construct(){
		
		parent::__construct();

		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName(); //pegar a controladora

		$cliente = Zend_Registry::get('Cliente');
		if($cliente[0]['IND_COM_SERV'] == "I")
		{
			$this->_referenceMap['PRODUTO']['refTableClass'] = array('table1' => 'ind_Model_DbTable_Produto','table2' => 'ind_Model_DbTable_ProdutoCliente');
			$this->_referenceMap['PRODUTO']['refColumns'] = array('table1' => 'CODIGO','table2' => 'PRODUTO');
		}

		else if($cliente[0]['IND_COM_SERV'] == "C")
		{
			$this->_referenceMap['PRODUTO']['refTableClass'] = array('table1' => 'com_Model_DbTable_Produto','table2' => 'com_Model_DbTable_ProdutoCliente');
			$this->_referenceMap['PRODUTO']['refColumns'] = array('table1' => 'CODIGO','table2' => 'PRODUTO');
		}

		else
		{
			$this->_referenceMap['PRODUTO']['refTableClass'] = 'core_Model_DbTable_Ativoprodutos';
			$this->_referenceMap['PRODUTO']['refColumns'] = 'CODIGO';
		}

		$this->model = new serv_Model_Manutitem();
	}
	
	
	public function atualizar($id1,$id2,$id3)
	{
		$sql = $this->_db->prepare('UPDATE '.$this->_name.' SET NUM_ITEM = NUM_ITEM - 1 WHERE CLIENTE='.$id1.' AND ITEM_PROGR='.$id2.' AND NUM_ITEM>'.$id3);
		$sql->execute();
	
	}

	public function beforeValidade($form, $dados)
	{
		 
		$controller 		= Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller 	= $controller->getControllerName(); // PEGA O NOME DA CONTROLADORA
		 
		if ($dados['NATUREZA_OPERACAO'] == 'L')
		{
			$form->getElement("CFOP")->setRequired(false);
		}
	
	}
	

	public function beforeInsert(array $data)
	{
		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName(); //pegar a controladora
	
		if ($nome_controller == 'manutitem')
		{
			
			if ($data['NATUREZA_OPERACAO'] == 'L'){
				$data['CFOP'] = NULL;
			}
	
		}
		return parent::beforeInsert($data);
	}
	
	
	public function afterInsert($id)
	{
	
		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName(); //pegar a controladora
	
		if ($nome_controller == 'manutitem')
		{
	
			$table_progr 		= new serv_Model_DbTable_Manut();
			$table_progritem 	= new Cisweb_Db_Abstract('manutitens');
	
			$cliente 		= $id['CLIENTE'];
			$item_progr             = $id['ITEM_PROGR'];
			$item 	 		= $id['NUM_ITEM'];
	
			$dados_progr 	= $table_progr->getAdapter()->fetchAll($table_progr->select()->where("CLIENTE = '$cliente' AND ITEM = '$item_progr'"));
	
			$dados_item 	= $table_progritem->getAdapter()->fetchAll($table_progritem->select()->where("CLIENTE = '$cliente' AND ITEM_PROGR = '$item_progr' and NATUREZA_OPERACAO <> 'L'"));
	
			if (count($dados_progr) != 0);// calcula o rateio ...
			{
	
				$valor_frete_total 	= 0;
				$valor_seguro_total 	= 0;
	
				$frete 					= $dados_progr[0]['VALOR_FRETE'];
				$seguro 				= $dados_progr[0]['VALOR_SEGURO'];
	
				$total 					= $this->model->calcula_total($dados_item);
	
				foreach ($dados_item as $key => $value)
				{
					$valor_frete 	= 0;
					$valor_seguro 	= 0;
	
					if ($frete != '')
					{
	
						$valor_frete 		= ($frete/$total) * $value['PRECO_TOTAL_ITEM'];
						$valor_frete_total += $valor_frete;
						$dif = ($frete - $valor_frete_total);
						if ($dif < 0) $dif1 = ($dif * (-1));
						else $dif1 = $dif;
						if ($dif1 <= 0.05) $valor_frete = ($valor_frete + $dif);
	
						$valor_frete = number_format($valor_frete, 2 , '.' ,'');
					}
	
	
					if ($seguro != '')
					{
	
						$valor_seguro 		= ($seguro/$total) * $value['PRECO_TOTAL_ITEM'];
						$valor_seguro_total += $valor_seguro;
						$dif = ($seguro - $valor_seguro_total);
						if ($dif < 0) $dif1 = ($dif * (-1));
						else $dif1 = $dif;
						if ($dif1 <= 0.05) $valor_seguro = ($valor_seguro + $dif);
	
						$valor_seguro = number_format($valor_seguro, 2 , '.' ,'');
					}
	
					$data['VALOR_FRETE'] 				= $valor_frete;
					$data['VALOR_SEGURO'] 				= $valor_seguro;
	
					$iditem 		= $value['ID'];
					$whereitens 	= "ID = '$iditem' and NATUREZA_OPERACAO <> 'L'";
					$table_progritem->update($data,$whereitens);
	
				}
			}
		}
	}
		
	public function beforeUpdate(array $data, $where)
	{
		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName(); //pegar a controladora
	
		if ($nome_controller == 'manutitem'){
	
			if ($data['NATUREZA_OPERACAO'] == 'L'){
				$data['CFOP'] = NULL;
			}
			
		}
	
		return parent::beforeUpdate($data, $where);
	
	}
	
	public function afterUpdate($id,$where)
	{
	
		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName(); //pegar a controladora
	
		if ($nome_controller == 'manutitem')
		{
	
			$table_progr 		= new serv_Model_DbTable_Manut();
			$table_progritem 	= new Cisweb_Db_Abstract('manutitens');
	
			
	
			$dados_progr 	= $table_progr->getAdapter()->fetchAll($table_progr->select()->where("CLIENTE = '$cliente' AND ITEM = '$item_progr'"));
	
	
			$dados_item 	= $table_progritem->getAdapter()->fetchAll($table_progritem->select()->where("CLIENTE = '$cliente' AND ITEM_PROGR = '$item_progr' and NATUREZA_OPERACAO <> 'L'"));
	
			if (count($dados_progr) != 0);// calcula o rateio ...
			{
	
				$valor_frete_total 		= 0;
				$valor_seguro_total 	= 0;
	
				$frete 					= $dados_progr[0]['VALOR_FRETE'];
				$seguro 				= $dados_progr[0]['VALOR_SEGURO'];
	
				$total 					= $this->model->calcula_total($dados_item);
	
				foreach ($dados_item as $key => $value)
				{
					$valor_frete 	= 0;
					$valor_seguro 	= 0;
	
					if ($frete != '')
					{
	
						$valor_frete 		= ($frete/$total) * $value['PRECO_TOTAL_ITEM'];
						$valor_frete_total += $valor_frete;
						$dif = ($frete - $valor_frete_total);
						if ($dif < 0) $dif1 = ($dif * (-1));
						else $dif1 = $dif;
						if ($dif1 <= 0.05) $valor_frete = ($valor_frete + $dif);
	
						$valor_frete = number_format($valor_frete, 2 , '.' ,'');
					}
	
	
					if ($seguro != '')
					{
	
						$valor_seguro 		= ($seguro/$total) * $value['PRECO_TOTAL_ITEM'];
						$valor_seguro_total += $valor_seguro;
						$dif = ($seguro - $valor_seguro_total);
						if ($dif < 0) $dif1 = ($dif * (-1));
						else $dif1 = $dif;
						if ($dif1 <= 0.05) $valor_seguro = ($valor_seguro + $dif);
	
						$valor_seguro = number_format($valor_seguro, 2 , '.' ,'');
					}
	
					$data['VALOR_FRETE'] 				= $valor_frete;
					$data['VALOR_SEGURO'] 				= $valor_seguro;
	
					$iditem 		= $value['ID'];
					$whereitens 	= "ID = '$iditem' and NATUREZA_OPERACAO <> 'L'";
					$table_progritem->update($data,$whereitens);
	
				}
	
			}
	
		}
	}
	
	
	public function beforeDelete($where)
	{
	
		$controller      = Zend_Controller_Front::getInstance()->getRequest();
		$nome_controller = $controller->getControllerName(); //pegar a controladora
	
		if ($nome_controller == 'manutitem')
		{
	
			$table_progr 		= new serv_Model_DbTable_Manut();
			$table_progritem 	= new Cisweb_Db_Abstract('manutitens');
	
			$cliente 			= $where[' CLIENTE = ? '];
			$item_progr 		= $where[' ITEM_PROGR = ? '];
			$item 	 			= $where[' NUM_ITEM = ? '];
	
			$dados_progr 		= $table_progr->getAdapter()->fetchAll($table_progr->select()->where("CLIENTE = '$cliente' AND ITEM = '$item_progr'"));
	
			$dados_item 		= $this->getAdapter()->fetchAll($this->select()->where("CLIENTE = '$cliente' AND ITEM_PROGR = '$item_progr' AND NUM_ITEM <> '$item' and NATUREZA_OPERACAO <> 'L'"));
	
			if (count($dados_progr) != 0);// calcula o rateio ...
			{
	
				$valor_frete_total 		= 0;
				$valor_seguro_total 	= 0;
	
				$frete 					= $dados_progr[0]['VALOR_FRETE'];
				$seguro 				= $dados_progr[0]['VALOR_SEGURO'];
	
				$total 					= $this->model->calcula_total($dados_item);
	
				foreach ($dados_item as $key => $value)
				{
					$valor_frete 	= 0;
					$valor_seguro 	= 0;
	
					if ($frete != '')
					{
	
						$valor_frete 		= ($frete/$total) * $value['PRECO_TOTAL_ITEM'];
						$valor_frete_total += $valor_frete;
						$dif = ($frete - $valor_frete_total);
						if ($dif < 0) $dif1 = ($dif * (-1));
						else $dif1 = $dif;
						if ($dif1 <= 0.05) $valor_frete = ($valor_frete + $dif);
	
						$valor_frete = number_format($valor_frete, 2 , '.' ,'');
					}
	
					if ($seguro != '')
					{
	
						$valor_seguro 		= ($seguro/$total) * $value['PRECO_TOTAL_ITEM'];
						$valor_seguro_total += $valor_seguro;
						$dif = ($seguro - $valor_seguro_total);
						if ($dif < 0) $dif1 = ($dif * (-1));
						else $dif1 = $dif;
						if ($dif1 <= 0.05) $valor_seguro = ($valor_seguro + $dif);
	
						$valor_seguro = number_format($valor_seguro, 2 , '.' ,'');
					}
	
					$data['VALOR_FRETE'] 				= $valor_frete;
					$data['VALOR_SEGURO'] 				= $valor_seguro;
	
					$iditem 		= $value['ID'];
					$whereitens 	= "ID = '$iditem' and NATUREZA_OPERACAO <> 'L'";
					$table_progritem->update($data,$whereitens);
	
				}
	
			}
	
		}
	
		return parent::beforeDelete($where);
	}
}
?>