<?php

class serv_Model_DbTable_Serv extends Zsam_Db_Table {

    protected $_name = 'serv';
    var $_restrict = null;
    var $_autocomplet = array('NUMERO', 'EMPRESA', 'CLIENTE');

    public function __construct() {
        $this->config = Zend_Registry::get('Cisweb_Config');
        parent::__construct();

        $controller = Zend_Controller_Front::getInstance()->getRequest();
        $nome_controller = $controller->getControllerName(); //pegar a controladora
        $nome_action = $controller->getActionName(); //pegar a controladora

        $auth = Zend_Auth::getInstance();
        if ($auth->hasIdentity()) {
            $user = $auth->getStorage()->read();
            $funcao = @$user['FUNCAO'];
            $id = @$user['ID'];
            $nome = @$user['NOME'];
            $level = @$user['NIVEL'];
            $acessorestrito = @$user['ACESSORESTRITO'];
        }

        if ($level < 3 && $this->config[0]['VENDEDOR_POR_CLIENTE_RESTRICT'] != 'N') {
            $this->_restrict = "(FECHAR_ORCAMENTO  != 'S' OR FECHAR_ORCAMENTO IS NULL AND TIPO = 'O') AND VENDEDOR = '$id'";
        } else {
            $this->_restrict = " FECHAR_ORCAMENTO  != 'S' OR FECHAR_ORCAMENTO IS NULL AND TIPO = 'O'";
        }

		$config_modulos = new Cisweb_Db_Abstract('config_modulos');
		$dados_modulos  = $config_modulos->fetchRow()->toArray();
		if ($acessorestrito == 'S' && $dados_modulos['USAR_ACESSO_RESTRITO'] == 'S' ){//neste caso tem o mesmo nível de um nivel 3
		    $this->_restrict = " FECHAR_ORCAMENTO  != 'S' OR FECHAR_ORCAMENTO IS NULL AND TIPO = 'O'";
		}

        if ($nome_controller == 'impressaoormclienteserv') {
            $this->_restrict = "(TIPO = 'O' OR TIPO = 'C') AND FECHAR_ORCAMENTO = 'S' ";
            $this->_conf['DATA_ORCAMENTO']['grid'] = true;
        }

        if ($nome_controller == 'impressaopedidoclienteserv') {
            $this->_restrict = "TIPO = 'P'";
            $this->_conf['DATA_ORCAMENTO']['grid'] 	= true;
			$this->_conf['NUMERO_NF']['grid']	  	= true;
			$this->_conf['DATA_NF']['grid'] 		= true;
        }

        if ($nome_controller == 'impressaocontratoserv') {
            //$this->_restrict = "(SITUACAO = 'S' OR SITUACAO = 'K')  AND TIPO = 'P' AND (BAIXA <> 'B' OR BAIXA IS NULL)";
            $this->_restrict = "TIPO = 'P'";
        }

        if ($nome_controller == 'servicosparafaturar') {
            $this->_restrict = "TIPO = 'P' AND  (BAIXA <> 'B' OR BAIXA IS NULL)";
        }

        if ($nome_controller == 'servicosparafaturarsemestoque') {
            $this->_restrict = "TIPO = 'P' AND (SITUACAO = 'N') AND (BAIXA <> 'B' OR BAIXA IS NULL)";
        }

        if ($nome_controller == 'servpedido') {
            $this->_restrict = "TIPO = 'P' AND BAIXA IS NULL";
            $this->_conf['DEPARTAMENTO']['edit'] = 'N';
            $this->_conf['GRID']['buttons'] = array('insert' => 'N', 'edit' => 'N', 'rem' => 'N');
            
            $this->_conf['GRID2'] = array('type' 		=> 'itemGridAuto',
                                          'configitem' 	=> 'GRID2',
                                          'model'       => 'serv_Model_DbTable_Ordemservico',
                                          'columns'     => array('SERVICO', 'EMPRESA','ITEM','NUMERO_CHAMADO','DATA_I','DATA_ATENDIMENTO'),//serão mostradas na grid
                                          'idWhere'  	=> array('SERVICO', 'EMPRESA'),
                                          'buttons'		=> array('edit'=>'S', 'del' => 'S'));
            
            $this->_referenceMap['GRID2'] = array(
                'columns' 		=> 'NUMERO',
                'refTableClass' => 'serv_Model_DbTable_Ordemservico',
                'refColumns' 	=> 'NUMERO',
                'refTitle' 		=> 'ITEM'
            );
        }

        if ($nome_controller == 'pedidolocacaointer') {
            $this->_restrict = "TIPO = 'P' AND BAIXA IS NULL";
            $this->_conf['DEPARTAMENTO']['edit'] = 'N';
            $this->_conf['GRID']['buttons'] = array('insert' => 'N', 'edit' => 'N', 'rem' => 'N');
            
            $this->_conf['GRID2'] = array('type' 		=> 'itemGridAuto',
                                          'configitem' 	=> 'GRID2',
                                          'model'       => 'serv_Model_DbTable_Ordemservico',
                                          'columns'     => array('SERVICO', 'EMPRESA','ITEM','NUMERO_CHAMADO','DATA_I','DATA_ATENDIMENTO'),//serão mostradas na grid
                                          'idWhere'  	=> array('SERVICO', 'EMPRESA'),
                                          'buttons'		=> array('edit'=>'S', 'del' => 'S'));
            
            $this->_referenceMap['GRID2'] = array(
                'columns' 		=> 'NUMERO',
                'refTableClass' => 'serv_Model_DbTable_Ordemservico',
                'refColumns' 	=> 'NUMERO',
                'refTitle' 		=> 'ITEM'
            );
        }
        
        if($nome_controller == 'reprovaitemservico'){
            $this->_restrict = "TIPO = 'O'";
        }
        
	}

    var $_conf = array(
        'ID'                            => array('edit' => 'N'),
        'NUMERO'                        => array("grid" => true, 'NULLABLE' => false, 'edit' => 'N'),
        'EMPRESA'                       => array("grid" => true, 'NULLABLE' => false, 'edit' => 'N'),
        'DATA'                          => array("grid" => true, 'edit' => 'N'),
        'CLIENTE'                       => array('edit' => 'N', 'autocomplete' => 'Y', "grid" => true, 'NULLABLE' => false, 'help' => 'help_digite_para_pesquisar'),
        'CONTATO'                       => array('NULLABLE' => false),
        'NOME_CLI'                      => array('edit' => 'N'),
        'CNPJ_CLI'                      => array('edit' => 'N'),
        'IE_CLI'                        => array('edit' => 'N'),
        'FATURA_MODELO'                 => array(),
        'VENDEDOR'                      => array('edit' => 'N'),
        'DATA_ORCAMENTO'                => array(),
        'DATA_PEDIDO'                   => array('edit' => 'N'),
        'LOCAL_UTILIZACAO'              => array(),
        'FECHAR_ORCAMENTO'              => array('edit' => 'N'),
        'TOTAL'                         => array('edit' => 'N'),
        'IMPRESSAO'                     => array('edit' => 'N'),
        'NUMERO_NF'                     => array('edit' => 'N'),
        'DATA_NF'                       => array('edit' => 'N'),
        'DATA_PREV_ENTREGA'             => array(),
        'OBS_PREV_ENTREGA'              => array(),
        'TIPO'                          => array('edit' => 'N'),
        'OBSLIVRECORPO'                 => array(),
        'REPRESENTANTE'                 => array(),
        'CODVENC'                       => array('title' => 'VENC', 'NULLABLE' => false),
        'VENCIMENTO'                    => array(),
        'OBSLOCACAO'                    => array(),
        'FORMA_ENVIO'                   => array('VP' => array('C' => 'COB_CARTEIRA', 'S' => 'BOLETO_SEMREGISTRO', 'R' => 'BOLETO_COMREGISTRO'), 'NULLABLE' => false),
        'FORMA_DO_PAGTO'                => array('VP' => array('I' => 'net_bank', 'R' => 'caixa_rap', 'D' => 'dinheiro_caixa', 'Q' => 'CHEQUE', 'C' => 'cartao_cred', 'T' => 'trans_contas', 'A' => 'debito_automatico')),
        'PORC_JUROS'                    => array('title' => 'JUROS'),
        'BANCO'                         => array(),
        'APROVACAO'                     => array(),
        'PRAZO_ENTREGA_DIAS'            => array(),
        'OBSERVACAO'                    => array(),
        'TIPO_PRAZO_LOCACAO'            => array('VP' => array('MESES' => 'MESES', 'DIAS' => 'DIAS')),
        'PRAZO_LOCACAO'                 => array(),
        'OBSERVACAO_PRAZO_ENTREGA'      => array(),
        'BAIXA'                         => array('edit' => 'N'),
        'DEPARTAMENTO'                  => array('NULLABLE' => false),
        'BT_NF'                         => array(),
        'BT_FATURA'                     => array(),
        'BT_CONTRATO'                   => array(),
        'BT_DUPLI'                      => array('edit' => 'N'),
        'REFERENCIA_CLIENTE'            => array('edit' => 'S'),
        'DESCRICAO_CUSTO_CONFIGURACAO'  => array('edit' => 'N'),
        'CUSTO_CONFIGURACAO'            => array('edit' => 'N'),
        'SITUACAO'                      => array('edit' => 'N'),
        'NUM_PROJETO'                   => array('edit' => 'N'),
        'STATUS'                        => array('edit' => 'N'),
        'STATUS_PADRAO'                 => array('edit' => 'N'),
        'FUNC_ALTERACAO'                => array('edit' => 'N'),
        'DATA_ALTERACAO'                => array('edit' => 'N'),
        'REVISAO'                       => array('edit' => 'N'),
        'DATASINC'                      => array(),
        'GRID' => array('type' => 'itemGridAuto', 
            'model'         => 'serv_Model_DbTable_Servitem',
            'configitem'    => 'GRID',
            'columns'       => array('NUMERO', 'EMPRESA', 'ITEM', 'SERVICO', 'DESCRICAO'), 
            'idWhere'       => array('NUMERO', 'EMPRESA'),
            'buttons'   	=> array('edit'=>'S', 'del' => 'S')),
        
        /*'GRID2' => array(),
        
        'GRID1' => array('type' => 'itemGridAuto', 
            'model' => 'serv_Model_DbTable_Servproduto',
            'configitem' => 'GRID1',
            'columns' => array('PRODUTO','QUANTIDADE','DESCRICAO_PROBLEMA','INFORMACAO_ADICIONAL','TOTAL_SERVICO'), 
            'idWhere' => array('NUMERO', 'EMPRESA'),
            'buttons'	=> array('edit'=>'S', 'del' => 'S')),*/
    );
    var $_referenceMap = array(
        'EMPRESA' => array(
            'columns' => 'EMPRESA',
            'refTableClass' => 'core_Model_DbTable_Empresa',
            'refColumns' => 'CODIGO',
            'refTitle' => 'EMPRESA'
        ),

        'CLIENTE' => array(
            'columns' => 'CLIENTE',
            'refTableClass' => 'serv_Model_DbTable_Cliente',
            'refColumns' => 'CODIGO',
            'refTitle' => 'CLIENTE'
        ),
        'CONTATO' => array(
            'columns' => 'CONTATO',
            'refTableClass' => 'core_Model_DbTable_Clientecontatoitem',
            'refColumns' => 'ID',
            'refTitle' => 'CONTATO',
            'semChave' => 'S'    //neste caso � quando temos uma chave primaria composta e incluimos o ID para poder fazer orelacionamento
        //porem o ID n�o � chave primaria e portanto no zsam form simple (linha +-103) desabilitamos o validador do zend para chave primaria
        ),
        'BANCO' => array(
            'columns' => 'BANCO',
            'refTableClass' => 'core_Model_DbTable_Banco',
            'refColumns' => 'CODIGO',
            'refTitle' => 'BANCO'
        ),
        'VENDEDOR' => array(
            'columns' => 'VENDEDOR',
            'refTableClass' => 'core_Model_DbTable_Usuario',
            'refColumns' => 'ID',
            'refTitle' => 'VENDEDOR'
        ),
        'CODVENC' => array(
            'columns' => 'CODVENC',
            'refTableClass' => 'core_Model_DbTable_Vencimento',
            'refColumns' => 'ID',
            'refTitle' => 'VENC'
        ),
        'OBSLOCACAO' => array(
            'columns' => 'OBSLOCACAO',
            'refTableClass' => 'serv_Model_DbTable_Obsfatura',
            'refColumns' => 'CODIGO',
            'refTitle' => 'OBSLOCACAO'
        ),
        
        'DEPARTAMENTO' => array(
            'columns' => 'DEPARTAMENTO',
            'refTableClass' => 'core_Model_DbTable_Depto',
            'refColumns' => 'DEPARTAMENTO',
            'refTitle' => 'DEPARTAMENTO'
        ),

        'GRID' => array(
            'columns' => 'ID',
            'refTableClass' => 'serv_Model_DbTable_Servitem',
            'refColumns' => 'ID',
            'refTitle' => 'ITEM'
        ),
        
        /*'GRID1' => array(
            'columns' => 'NUMERO',
            'refTableClass' => 'serv_Model_DbTable_Servproduto',
            'refColumns' => 'NUMERO',
            'refTitle' => 'ITEM'
        )*/

    );

    public function beforeInsert(array $data) {

        $controller = Zend_Controller_Front::getInstance()->getRequest();
        $nome_controller = $controller->getControllerName(); //pegar a controladora

        $table = new core_Model_DbTable_Empresa();
        $where = "CODIGO = " . $data['EMPRESA'];
        $campos = $table->getAdapter()->fetchAll($table->select()->where($where));
        $soma = @$campos[0]['ULTIMO_SERV'] + 1;
        $data_emp = array('ULTIMO_SERV' => $soma);

        $table->update($data_emp, $where); // atualiza a tabela empresa antes de inserir a fatura

        $data['NUMERO'] = $soma; // recebe o num da fatura da tabela empresa
        $date = date('Y-m-d');
        $data['DATA'] = $date;

        if($data['TIPO'] == '') {
            $data['TIPO'] = 'O';
        }
        return parent::beforeInsert($data);
    }

    public function deleteCascade($id, $emp) {

        $controller = Zend_Controller_Front::getInstance()->getRequest();
        $nome_controller = $controller->getControllerName(); // PEGA O NOME DA CONTROLADORA

        $table = new serv_Model_DbTable_Faturaitem();
        $adapter = $table->getAdapter();
        $where = $adapter->quoteInto('NUMERO = ?', $id) . ' AND ' . $adapter->quoteInto('EMPRESA = ?', $emp);
        $table->delete($where);
    }
    
}

?>