<?php

class Zsam_Util {

    /**
     * Caso a regra de negócio não contemple uma alteração de case forçada
     * Utilize $_case = 'none'
     */
    public static function getDefaultCase() {
        $case = 'UPPER';
        return $case;
    }

    public static function replace($texto, $array) {
        if (is_array($array)) {
            foreach ($array as $k => $v) {
                $texto = str_replace($k, $v, $texto);
            }
        }
        return $texto;
    }

    public static function getUserInfo($info) {
        $auth = Zend_Auth::getInstance();
        if ($auth->hasIdentity()) {
            // yes ! we get his role
            $user = $auth->getStorage()->read();
            return @$user[$info];
        } else
            return '';
    }

    public static function dateNow() {
        return date('d/m/Y');
    }

    public static function formataSaldo($valor) {

        if ($valor > 0) {
            $txt = Zend_Locale_Format::toFloat($valor) . ' C';
        } else {
            $txt = "<font color='red'>" . Zend_Locale_Format::toFloat($valor * -1) . ' D</font>';
        }
        return $txt;
    }

    public static function datetimeNow() {
        return date('d/m/Y H:i:s');
    }

    public static function date($strdata) {
        if ($strdata == '')
            return '';
        $vl = Zend_Locale_Format::getDate($strdata, array('date_format' => 'yyyy-MM-dd'));
        return $vl['day'] . '/' . $vl['month'] . '/' . $vl['year'];
    }

    public static function adddays($data, $days) {
        $data = Zsam_Util::mkdate($data);
        $data = $data + 60 * 60 * 24 * $days;
        return date('d/m/Y', $data);
    }

    public static function mkdate($data) {
        $data = Zend_Locale_Format::getDate($data);
        $data = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
        return $data;
    }

    public static function dateBetween($data, $ini, $fim) {

        $data = Zsam_Util::mkdate($data);
        $ini = Zsam_Util::mkdate($ini);
        $fim = Zsam_Util::mkdate($fim);

        if ($data >= $ini && $data <= $fim)
            return true;
        else
            return false;
    }

    public static function datetime($strdata) {
        if ($strdata == '')
            return '';
        $vl = Zend_Locale_Format::getDate($strdata, array('date_format' => 'yyyy-MM-dd HH:mm:ss'));
        return $vl['day'] . '/' . $vl['month'] . '/' . $vl['year'] . ' ' . @$vl['hour'] . ':' . @$vl['minute'] . ':' . @$vl['second'];
    }

    public static function dateSql($strdata) {
        $vl = Zend_Locale_Format::getDate($strdata);
        return $vl['year'] . '-' . $vl['month'] . '-' . $vl['day'];
    }

    public static function datetimeSql($strdata) {
        $vl = Zend_Locale_Format::getDateTime($strdata);
        return $vl['year'] . '-' . $vl['month'] . '-' . $vl['day'] . ' ' . $vl['hour'] . ':' . $vl['minute'] . ':' . $vl['second'];
    }

    public static function showMessage($message, $translate, $alert) {

        if ($translate)
            $message = $translate = Zend_Registry::get('Zend_Translate')->_($message);
        if ($alert)
            return '<script>alert("' . $message . '")</script>';
        return $message;
    }
    
    public static function showException($exception, $translate, $alert) {

        if ($translate){
            $translate = Zend_Registry::get('Zend_Translate');
            if ($translate->isTranslated($exception->getCode()))
                    $message = $translate->_($exception->getCode());
            else
                    $message = $exception->getMessage();
        }else{
            $message = $exception->getMessage();
        }
        
        if ($alert)
            return '<script>alert("' . $message . '")</script>';            
        else
            return '<font color="red">'.$message.'</font>';
    }

}