<?php

class Zsam_Validate_NfComplemento extends Zend_Validate_Abstract {
    const NFERRADA = 'nf_nao_encontrada';

    /**
     * @var array
     */
    protected $_messageTemplates = array(
        self::NFERRADA => "NFe nao encontrada para esta Empresa",
    );
    protected $_opts;

    public function __construct($options = array()) {
        $this->_opts = $options;
    }

    public function isValid($value, $context = null) {

		if($context['TIPO'] == 2){
			$table_nf = new Cisweb_Db_Abstract('nf');
			$num_nf   = $context['NF_REFERENCIA'];
			$empresa  = $context['EMPRESA'];
			$dados_nf = $table_nf->select()->where('NUMERO = ?', $num_nf)->where('EMPRESA = ?', $empresa);
			$dados_nf = $table_nf->fetchAll($dados_nf)->toArray();
			
			if(count($dados_nf) == 0){
				$this->_error(self::NFERRADA);
				//echo $this->message = Zsam_Util::showMessage($this->_createMessage(self::MENORQUE, $value),true,true);
				return false;
			}
		}
        return true;
    }

}
