<?php

class Zsam_Validate_Participacao extends Zend_Validate_Abstract {
    const MENORCEM = 'maior_cem';
    const MAIORZERO = 'maior_zero';
    const TOTAL = 'soma_cem';

    /**
     * @var array
     */
    protected $_messageTemplates = array(
        self::MENORCEM => "Este campo ou a soma total dos campos deve dar menos que cem",
        self::MAIORZERO => "Por favor preencher o campo com um valor maior que zero",
        self::TOTAL => "A soma dos campos deve ser igual a cem"
    );
    protected $_opts;

    public function __construct($options = array()) {
        $this->_opts = $options;
    }

    public function isValid($value, $context = null) {
        if ($context['PARTICIPACAO1'] > 100) {
            $this->_error(self::MENORCEM);
            //echo $this->message = Zsam_Util::showMessage($this->_createMessage(self::MENORQUE, $value),true,true);
            return false;
        }

        if ($context['PARTICIPACAO1'] < 100) {
            $soma = $context['PARTICIPACAO1']+$context['PARTICIPACAO2']+$context['PARTICIPACAO3'];
            
            if ($context['PARTICIPACAO2'] >= 100 || $context['PARTICIPACAO3'] >= 100) {
                $this->_error(self::MENORCEM);
                //echo $this->message = Zsam_Util::showMessage($this->_createMessage(self::MENORQUE, $value),true,true);
                return false;
            }
            if ($soma < 100 || $soma > 100) {
                $this->_error(self::TOTAL);
                //echo $this->message = Zsam_Util::showMessage($this->_createMessage(self::MENORQUE, $value),true,true);
                return false;
            }
            
        }

        if ($context['PARTICIPACAO1'] <= 0) {
            $this->_error(self::MAIORZERO);
            //echo $this->message = Zsam_Util::showMessage($this->_createMessage(self::MENORQUE, $value),true,true);
            return false;
        }
        
        if ($context['COMPRAR2'] != 0 && $context['PARTICIPACAO2'] <= 0){
             $this->_error(self::MAIORZERO);
            //echo $this->message = Zsam_Util::showMessage($this->_createMessage(self::MENORQUE, $value),true,true);
            return false;
        }
        
        if ($context['COMPRAR3'] != 0 && $context['PARTICIPACAO3'] <= 0){
             $this->_error(self::MAIORZERO);
            //echo $this->message = Zsam_Util::showMessage($this->_createMessage(self::MENORQUE, $value),true,true);
            return false;
        }

        return true;
    }

}
